<?php

namespace App\Http\Controllers\Therapists;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Archive;
use App\Http\Requests\Therapists\TherapistArchives\CreateRequest;
use App\Http\Resources\Web\ArchivesResource;
use Excel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TherapistArchivesController extends Controller
{
    /********* Initialize Permission based Middlewares  ***********/
  public function __construct()
  {
      $this->middleware('auth');
      $this->middleware('therapist');
      // $this->middleware('permission:therapist_archives.index');
      // $this->middleware('permission:therapist_archives.create',['only' => ['store']]);
      // $this->middleware('permission:therapist_archives.update',['only' => ['update']]);
      // $this->middleware('permission:therapist_archives.delete',['only' => ['destroy']]);
      // $this->middleware('permission:therapist_archives.export',['only' => ['export']]);
      // $this->middleware('permission:therapist_archives.import',['only' => ['import']])
      // $this->middleware('permission:therapist_archives.update|therapist_archives.is_active',['only' => ['updateStatus']]);
  }

  /********* Getter For Pagination, Searching And Sorting  ***********/
  public function getter($req = null,$export = null)
  {
    $therapist = auth()->user()->therapist;
    if($req != null){
      $therapist_archives =  $therapist->therapist_archives()->withAll();
      if($req->trash && $req->trash == 'with'){
        $therapist_archives =  $therapist_archives->withTrashed();
      }
      if($req->trash && $req->trash == 'only'){
        $therapist_archives =  $therapist_archives->onlyTrashed();
      }
      if($req->column && $req->column != null && $req->search != null){
          $therapist_archives = $therapist_archives->whereLike($req->column,$req->search);
        }
       else if($req->search && $req->search != null){

            $therapist_archives = $therapist_archives->whereLike(['name','description'],$req->search);
        }
      if($req->sort && $req->sort['field'] != null && $req->sort['type'] != null){
          $therapist_archives = $therapist_archives->OrderBy($req->sort['field'],$req->sort['type']);
      }
      else
      {
        $therapist_archives = $therapist_archives->OrderBy('id','desc');
      }
      if($export != null){ // for export do not paginate
        $therapist_archives = $therapist_archives->get();
        return $therapist_archives;
      }
      $totalTherapistArchives = $therapist_archives->count();
      $therapist_archives = $therapist_archives->paginate($req->perPage);
      $therapist_archives = ArchivesResource::collection($therapist_archives)->response()->getData(true);

      return $therapist_archives;
    }
    $therapist_archives = ArchivesResource::collection($therapist->therapist_archives()->withAll()->orderBy('id','desc')->paginate(10))->response()->getData(true);
    return $therapist_archives;
  }

  /********* FETCH ALL TherapistArchives ***********/
    public function index()
    {
        $therapist_archives =  $this->getter();
        $response = generateResponse($therapist_archives,count($therapist_archives['data']) > 0 ? true:false,'TherapistArchives Fetched Successfully',null,'collection');
        return response()->json($response, 200);
    }

  /********* FILTER TherapistArchives FOR Search ***********/
   public function filter(Request $request){
     $therapist_archives = $this->getter($request);
     $response = generateResponse($therapist_archives,count($therapist_archives['data']) > 0 ? true:false,'Filter TherapistArchives Successfully',null,'collection');
     return response()->json($response, 200);
   }

    /********* ADD NEW TherapistArchive ***********/
    public function store(CreateRequest $request)
    {
      $therapist = auth()->user()->therapist;
      try{
      DB::beginTransaction();
      $request->merge(['created_by_user_id'=>auth()->user()->id]);
      $data = $request->all();
      $data['image'] = uploadCroppedFile($request,'image','therapist_archives');
      $therapist_archive = $therapist->therapist_archives()->create($data);
      $therapist_archive->slug = Str::slug($therapist_archive->name . ' ' . $therapist_archive->id, '-');
      $therapist_archive->tags()->sync($request->tag_ids);
      $therapist_archive->save();
      $therapist_archive = $therapist->therapist_archives()->withAll()->find($therapist_archive->id);
      $therapist_archive = new ArchivesResource($therapist_archive);
      DB::commit();
    }
      catch (\Exception $e) {
        DB::rollBack();
        request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
     }
      return redirect()->back();
    }

    /********* View RECORD TO EDIT Or Display ***********/
    public function show( $therapist_archive)
    {
        $therapist = auth()->user()->therapist;
        if($therapist_archive->therapist_id != $therapist->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_archive = $therapist->therapist_archives()->withAll()->find($therapist_archive);
        if($therapist_archive){
          $therapist_archive = new ArchivesResource($therapist_archive);
          $response = generateResponse($therapist_archive,true,'TherapistArchive Fetched Successfully',null,'object');
        }
        else{
          $response = generateResponse(null,false,'TherapistArchive Not FOund',null,'object');
        }
        return response()->json($response, 200);
    }

    /********* UPDATE TherapistArchive ***********/
    public function update(CreateRequest $request, Archive $therapist_archive)
    {
        // dd($request->all());
        $therapist = auth()->user()->therapist;
        if($therapist_archive->therapist_id != $therapist->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
      try{
        DB::beginTransaction();
        $request->merge(['last_updated_by_user_id'=>auth()->user()->id]);
        $data = $request->all();
        if ($request->image) {
            $data['image'] = uploadCroppedFile($request,'image','therapist_archives',$therapist_archive->image);
        } else {
            $data['image'] = $therapist_archive->image;
        }
        $data['slug'] = Str::slug($data['name'] . ' ' . $therapist_archive->id, '-');
        $therapist_archive->update($data);
        $therapist_archive->tags()->sync($request->tag_ids);
        DB::commit();
      }
        catch (\Exception $e) {
          DB::rollBack();
          request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
       }
       return redirect()->back();
    }

    /********* UPDATE TherapistArchive Status***********/
    public function updateStatus(Request $request,Archive $therapist_archive){
        $therapist = auth()->user()->therapist;
        if($therapist_archive->therapist_id != $therapist->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_archive->update([
          'is_active' => $therapist_archive->is_active == 1 ? 0:1
        ]);
        $response = generateResponse(null,true,'TherapistArchive Status Updated Successfully',null,'object');
        return response()->json($response, 200);
    }


    /********* DELETE TherapistArchive ***********/
    public function destroy(Request $request,Archive $therapist_archive)
    {
        $therapist = auth()->user()->therapist;
        if($therapist_archive->therapist_id != $therapist->id){
            request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
            return redirect()->back();
        }
          if($therapist_archive->trashed()) {
            request()->session()->flash('alert',['message' => 'Already in Trash','type' => 'error']);
          }
          else{
            $therapist_archive->delete();
          }
          return redirect()->back();
    }
    /*********Permanently DELETE TherapistArchive ***********/
    public function destroyPermanently(Request $request,$therapist_archive)
    {
        $therapist= auth()->user()->therapist;
        $therapist_archive = $therapist->therapist_archives()->withTrashed()->find($therapist_archive);
        if($therapist_archive){
            if($therapist_archive->therapist_id != $therapist->id){
                return redirect()->back()->withErrors([
                    'message' => 'Invalid Request',
                    'type' => 'error'
                ]);
            }
          if ($therapist_archive->trashed()) {
            $therapist_archive->forceDelete();
            $response = generateResponse(null,true,'TherapistArchive Deleted Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistArchive is not in trash to delete permanently',null,'object');
          }
        }
        else{
          $response = generateResponse(null,false,'TherapistArchive not found',null,'object');
        }
          return response()->json($response, 200);
    }
    /********* Restore TherapistArchive ***********/
    public function restore(Request $request,$therapist_archive)
    {
      $therapist= auth()->user()->therapist;
      $therapist_archive = $therapist->therapist_archives()->withTrashed()->find($therapist_archive);
          if ($therapist_archive->trashed()) {
            $therapist_archive->restore();
            $response = generateResponse(null,true,'TherapistArchive Restored Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistArchive is not trashed',null,'object');
          }
          return response()->json($response, 200);
    }
}
